/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Created by S.Guillitte 
//based on Pustules by nimitz :https://www.shadertoy.com/view/XdSXDc
//Using code from Knighty : https://www.shadertoy.com/view/XlX3zB

#define PI	3.14159265359
#define PI2	( PI * 2.0 )

float time=iGlobalTime;

// 1 = 3*3*3 kernel, 0 = 2*2*2 kernel
#if 0
float k2 = 1.;
const int m =1;
#else
float k2 = .7;
const int m =0;
#endif


float hash( in vec3 p ) 
{
    return fract(sin(p.x*15.32758341+p.y*39.786792357+p.z*59.4583127+7.5312) * 43758.236237153)-.5;
}


vec3 voronoi(in vec3 p)
{    
    vec3 ip = floor(p);
    vec3 fp = fract(p);
	float rid = -1.;
    vec2 r = vec2(2.);
    for (int i=-1; i<=m; i++) 
	for (int j=-1; j<=m; j++) 
	for (int k=-1; k<=m; k++) 
	{
		vec3 g = vec3(i, j, k);
        float h = hash(ip - g);
        vec3 pp = fp +g +h*k2;
        float d = dot(pp, pp);

        if (d < r.x)
		{
            r.y = r.x;
            r.x = d;
            rid = h +.5;
		}
        else if(d < r.y)
		{
    		r.y = d;
		}
	}    
    return vec3(r,rid);
}



//-------------------------------------------------
//From https://www.shadertoy.com/view/XtXGRS#
vec2 rotate(in vec2 p, in float t)
{
	return p * cos(-t) + vec2(p.y, -p.x) * sin(-t);
}


float map( vec3 p)
{
	float d = length(p)-1.5;
    vec3 vor = voronoi(p*5.0);
    vor.y += vor.x;
    d = max( d, (d-((vor.x+vor.y)-1.))*.15 );
	return d;	
       	
}


vec3 calcNormal(in vec3 p)
{
	const vec2 e = vec2(0.0001, 0.0);
	return normalize(vec3(
		map(p + e.xyy) - map(p - e.xyy),
		map(p + e.yxy) - map(p - e.yxy),
		map(p + e.yyx) - map(p - e.yyx)));
}

float march(in vec3 ro, in vec3 rd)
{
	const float maxd = 5.0;
	const float precis = 0.001;
    float h = precis * 2.0;
    float t = 0.0;
	float res = -1.0;
    for(int i = 0; i < 128; i++)
    {
        if(h < precis*t || t > maxd) break;
	    h = map(ro + rd * t);
        t += h;
    }
    if(t < maxd) res = t;
    return res;
}

vec3 transform(in vec3 p)
{
    p.yz = rotate(p.yz, iGlobalTime * 0.2 + (iMouse.y-0.5*iResolution.y)*PI2/360.);
    p.zx = rotate(p.zx, iGlobalTime * 0.125 + (0.5*iResolution.x-iMouse.x)*PI2/360.);
    return p;
}

void main(void)
{
	vec2 p = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
	vec3 col = vec3(.3);
   	vec3 rd = normalize(vec3(p, -2.));
	vec3 ro = vec3(0.0, 0.0, 3.5);
    vec3 li = normalize(vec3(0.5, 0.8, 3.0));
    ro = transform(ro);
	rd = transform(rd);
	li = transform(li);
    
    //Marble background from Nimitz's Pustule
    vec3 bgvor = voronoi(rd*4.2)*0.35;
    bgvor += voronoi(rd*9.)*0.25;
    bgvor += voronoi(rd*25.)*0.1;
    bgvor.y -= bgvor.x;
    col = ((bgvor.z*.6 + 0.2)*(.5 - bgvor.x*1.5*(1.5 - bgvor.y*10.)))
        *(sin(vec3(1.7,1.5,1)+.5 + voronoi(rd*24.).x)*0.5 + 0.5);
    
    float t = march(ro, rd);
    if(t > -0.001)
    {
        vec3 pos = ro + t * rd;
        vec3 nor = calcNormal(pos);
		float dif = clamp(dot(nor, li), 0.0, 1.0);
        float c = voronoi(pos*5.).x;
        vec3 col1 =vec3(c*c,c,.9)*c;
        nor = reflect(rd, nor);
        col1 += pow(max(dot(li, nor), 0.0), 25.0)*vec3(.5);
	    col = .3+.6*mix( col, col1, t );
        col = col * dif;
        //col = pow(col, vec3(.5));
	}
    
   	gl_FragColor = vec4(col, 1.0);
}